import websocket
import json
import time



TOKEN = "eyJhbGciOiJFUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1c2VySWQiOjUwMDYyNiwiYWdlbnRJZCI6ODYwODUyLCJlbmRwb2ludElkIjoiYWdlbnRfODYwODUyIiwicHVycG9zZSI6Im1jcC1lbmRwb2ludCIsImlhdCI6MTc2MTExOTAzNSwiZXhwIjoxNzkyNjc2NjM1fQ.IMIQS0BxofqKlwEd3fdEbF8pWpradVJUrttzJrHhLA-NTMRQf5C_w2-DSRJlQrMg-KQLLeGZJAzwMJs03cY3EQ"  # token của bạn
WS_URL = f"wss://api.xiaozhi.me/mcp/?token={TOKEN}"

PLAY_COMMAND = {
    "jsonrpc": "2.0",
    "method": "tools/call",
    "params": {
        "name": "self.audio.play_http",
        "arguments": {
            "url": "http://192.168.1.231:5000/play?file=nang_tho.mp3"
        }
    },
    "id": 100
}

def on_message(ws, message):
    print("📩 Nhận:", message)
    try:
        msg = json.loads(message)
    except Exception:
        return

    if msg.get("method") == "initialize":
        reply = {
            "jsonrpc": "2.0",
            "id": msg["id"],
            "result": {
                "protocolVersion": "2024-11-05",
                "capabilities": {"tools": {}},
                "serverInfo": {"name": "python-mcp-client", "version": "1.0.0"}
            }
        }
        ws.send(json.dumps(reply))
        print("🔧 Gửi phản hồi initialize...")

    elif msg.get("method") == "notifications/initialized":
        print("✅ Initialized hoàn tất, đợi 5s rồi gửi tools/call...")
        time.sleep(5)
        ws.send(json.dumps(PLAY_COMMAND))
        print("🚀 Đã gửi tools/call phát nhạc.")

    elif msg.get("method") == "tools/list":
        reply = {
            "jsonrpc": "2.0",
            "id": msg["id"],
            "result": {"tools": [], "nextCursor": ""}
        }
        ws.send(json.dumps(reply))
        print("📋 Trả danh sách tools trống...")

    elif msg.get("method") == "ping":
        if "id" in msg:
            pong = {
                "jsonrpc": "2.0",
                "id": msg["id"],
                "result": {"ok": True}
            }
            ws.send(json.dumps(pong))
            print("🏓 Ping → Gửi Pong OK.")
        else:
            print("🏓 Ping (no id) → bỏ qua.")

def on_open(ws):
    print("✅ Kết nối WSS thành công.")

def on_error(ws, error):
    print("❌ Lỗi:", error)

def on_close(ws, *args):
    print("🔌 Đóng kết nối, sẽ tự reconnect sau 5s...")
    time.sleep(5)
    connect()

def connect():
    ws = websocket.WebSocketApp(
        WS_URL,
        on_message=on_message,
        on_open=on_open,
        on_error=on_error,
        on_close=on_close
    )
    ws.run_forever(ping_interval=20, ping_timeout=10)

if __name__ == "__main__":
    connect()